return function (dt)
    local playing = ac.currentlyPlaying()
    local p = math.min(ui.windowWidth() / 2, ui.windowHeight() * 1.2)
    local x = p - 200
    local y = (ui.windowHeight() - 240) / 2
    local background_resolution_x = 1280
    local background_resolution_y = 740

    
    display.text {
        text = string.format("Water Temperature"),
        pos = vec2(50, 175),
        letter = vec2(20, 30),
        font = "c7_new",
        width = 1,
        alignment = 1,
        spacing = -4,
        color = rgbm(90,90,90,90)
    }

    display.text {
        text = string.format("RPM "),
        pos = vec2(50, 50),
        letter = vec2(20, 30),
        font = "c7_new",
        width = 1,
        alignment = 1,
        spacing = -4,
        color = rgbm(90,90,90,90)
    }

    display.text {
        text = string.format("Oil Temperature"),
        pos = vec2(50, 325),
        letter = vec2(20, 30),
        font = "c7_new",
        width = 1,
        alignment = 1,
        spacing = -4,
        color = rgbm(90,90,90,90)
    }

    display.text {
        text = string.format("Oil Pressure"),
        pos = vec2(350, 175),
        letter = vec2(20, 30),
        font = "c7_new",
        width = 1,
        alignment = 1,
        spacing = -4,
        color = rgbm(90,90,90,90)
    }

    display.text {
        text = string.format("Lap Time"),
        pos = vec2(350, 50),
        letter = vec2(20, 30),
        font = "c7_new",
        width = 1,
        alignment = 1,
        spacing = -4,
        color = rgbm(90,90,90,90)
    }

    display.text {
        text = string.format("Speed in KMH"),
        pos = vec2(650, 50),
        letter = vec2(20, 30),
        font = "c7_new",
        width = 1,
        alignment = 1,
        spacing = -4,
        color = rgbm(90,90,90,90)
    }

    display.text {
        text = string.format("Fuel in L"),
        pos = vec2(350, 325),
        letter = vec2(20, 30),
        font = "c7_new",
        width = 1,
        alignment = 1,
        spacing = -4,
        color = rgbm(90,90,90,90)
    }

    display.text {
        text = string.format("Gear in Numbers"),
        pos = vec2(650, 325),
        letter = vec2(20, 30),
        font = "c7_new",
        width = 1,
        alignment = 1,
        spacing = -4,
        color = rgbm(90,90,90,90)
    }

    display.text {
        text = string.format("Battery Voltage"),
        pos = vec2(650, 175),
        letter = vec2(20, 30),
        font = "c7_new",
        width = 1,
        alignment = 1,
        spacing = -4,
        color = rgbm(90,90,90,90)
    }
    

    display.text {
        text = string.format("%.f", car.waterTemperature),
        pos = vec2(50, 200),
        letter = vec2(45, 90),
        font = "c7_new",
        width = 1,
        alignment = 1,
        spacing = -10,
        color = rgbm(45,45,45,45)
    }
    display.text {
        text = string.format("%.f", car.oilTemperature),
        pos = vec2(50, 350),
        letter = vec2(45, 90),
        font = "c7_new",
        width = 1,
        alignment = 1,
        spacing = -10,
        color = rgbm(90,90,90,90)
    }

    display.text {
        text = string.format("%.1f",car.oilPressure),
        pos = vec2(350, 200),
        letter = vec2(45, 90),
        font = "c7_new",
        width = 46,
        alignment = 1,
        spacing = 0
    }

    display.text {
        text = string.format("%.1f", car.fuel/car.maxFuel*100),
        pos = vec2(350, 350),
        letter = vec2(40, 80),
        font = "c7_new",
        width = 46,
        alignment = 1,
        spacing = 0
    }
    
    display.text {
        text = string.format("%.f", car.gear),
        pos = vec2(650, 350),
        letter = vec2(40, 80),
        font = "c7_new",
        width = 46,
        alignment = 0.5,
        spacing = 0
    }
    -- numeric battery gauge
    display.text {
        text = string.format("%.1f", car.batteryVoltage), -- %.1f = 1 digit after comma, %.2f = 2 digits etc
        pos = vec2(650, 200),
        letter = vec2(45, 90),
        font = "c7_new",
        width = 46,
        alignment = 1,
        spacing = 0
    }

    display.text {
        text = string.format("%.f",car.rpm),
        pos = vec2(50, 75),
        letter = vec2(45, 90),
        font = "c7_new",
        width = 46,
        alignment = 1,
        spacing = 0
    }

    local time = car.lapTimeMs -- preparation for conversion from ms to minutes, seconds, milliseconds
    local formattedTime =
        string.format(
        "%02d:%02d:%02d",
        math.floor((time / (1000 * 60))) % 60,
        math.floor((time / 1000)) % 60,
        math.floor((time % 1000) / 100)
    )
    display.text {
        text = formattedTime,
        pos = vec2(300, 75),
        letter = vec2(45, 90),
        font = "c7_new",
        width = 46,
        alignment = 1,
        spacing = -3
    }

    display.text {
        text = string.format("%.f",car.poweredWheelsSpeed),
        pos = vec2(700, 75),
        letter = vec2(45, 90),
        font = "c7_new",
        width = 46,
        alignment = 1,
        spacing = 0
    }
  end