if car.isAIControlled then
    return nil
end

local drsAnimFileName = "DRS.ksanim" -- Replace with your ksanim file name
local prevDrsActive = false

function script.update(dt)
    local drsActive = car.drsActive == true

    -- Play animation only when DRS is activated (rising edge)
    if drsActive and not prevDrsActive then
        local drsAnimPath = drsAnimFileName  -- resolved relative to car extension folder
        -- Use playOnce if available, otherwise play
        if ksAnimation.playOnce then
            ksAnimation.playOnce(drsAnimPath)
        else
            ksAnimation.play(drsAnimPath)
        end
    end

    prevDrsActive = drsActive
end